﻿<%@ Page Language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
		<title>Wycena środków ewidencji walutowej</title>
		<script runat="server">

            public class Params : ContextBase {
                public Params(Context context) : base(context) {
                    data = Context.Session.Login.CurrentDate;
                }

                Date data;
                [Caption("Wycena na dzień")]
                [Priority(1)]
                [Required]
                public Date Data {
                    get { return data; }
                    set {
                        if (value==Date.Empty || value==Date.MaxValue)
                            data = Context.Session.Login.CurrentDate;
                        else
                            data = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            EwidencjaSP ewidencja;
            [Context]
            public EwidencjaSP Ewidencja {
                set { ewidencja = value; }
            }
		    
            Params pagePars;
            [Context]
            public Params PageParams {
                set { pagePars = value; }
            }

            public class Comparer : IComparer {
                private Params pagePars;
                
                public Comparer(Params p)
                {
                    pagePars = p;
                }

                public int Compare(object x, object y) {
                    Date dx = GetDate(x);
                    Date dy = GetDate(y);
                    if (dx.CompareTo(dy) != 0)
                        return dx.CompareTo(dy);
                    //jak daty się zgadzają sortuję po dokumencie
                    string sx = GetString(x);
                    string sy = GetString(y);
                    return sx.CompareTo(sy);
                }

                Date GetDate(object obj) {
                    if (obj == null)
                        return Date.Empty;
                    ZasobMW zasób = obj as ZasobMW;
                    if (zasób != null)
                        return zasób.Partia.Data;
                    ObrotMW obrót = (ObrotMW)obj;
                    return Date.Min(obrót.Przychod.Data, obrót.Rozchod.Data);
                }

                string GetString(object obj) {
                    if (obj == null)
                        return String.Empty;
                    ZasobMW zasób = obj as ZasobMW;
                    if (zasób != null)
                        return zasób.Zaplata.NumerDokumentu;
                    ObrotMW obrót = (ObrotMW)obj;
                    return obrót.Przychod.Data <= pagePars.Data ? obrót.Wplata.NumerDokumentu : obrót.Wyplata.NumerDokumentu;
                }
            }
		        
            protected void OnContextLoad(object sender, EventArgs e) {
                ReportHeader1["EWIDENCJA"] = ewidencja.Nazwa;
                ReportHeader1["WALUTA"] = ewidencja.Waluta.ToString();
                ReportHeader1["DATA"] = pagePars.Data.ToString();                
                
                StanMagazynuInfo info = new StanMagazynuInfo(dc.Context, ewidencja, pagePars.Data);
                ArrayList rows = new ArrayList();                               
                rows.AddRange(info.Zasoby);
                rows.AddRange(info.Obroty);
                rows.Sort(new Comparer(pagePars));

                Grid1.DataSource = rows;
            }
		    
            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                ZasobMW zasób = args.Row as ZasobMW;
                if (zasób != null) {
                    colData.EditValue = zasób.Partia.Data;
                    colDokument.EditValue = zasób.Zaplata.NumerDokumentu;
                    colKontrahent.EditValue = zasób.Zaplata.Podmiot;
                    if (zasób.Kierunek == KierunekPlatnosci.Przychod) {
                        colKwotaZ.EditValue = zasób.Partia.Kwota;
                        colWartośćZ.EditValue = zasób.Partia.Wartosc;
                    }
                    else {
                        colKwotaS.EditValue = zasób.Partia.Kwota;
                        colWartośćS.EditValue = zasób.Partia.Wartosc;
                    }
                }
                else {
                    ObrotMW obrót = (ObrotMW)args.Row;
                    if (obrót.Przychod.Data <= pagePars.Data) {
                        colData.EditValue = obrót.Przychod.Data;
                        colDokument.EditValue = obrót.Wplata.NumerDokumentu;
                        colKontrahent.EditValue = obrót.Wplata.Podmiot;
                        colKwotaZ.EditValue = obrót.Przychod.Kwota;
                        colWartośćZ.EditValue = obrót.Przychod.Wartosc;
                    }
                    else {
                        colData.EditValue = obrót.Rozchod.Data;
                        colDokument.EditValue = obrót.Wyplata.NumerDokumentu;
                        colKontrahent.EditValue = obrót.Wyplata.Podmiot;
                        colKwotaS.EditValue = obrót.Rozchod.Kwota;
                        colWartośćS.EditValue = obrót.Rozchod.Wartosc;
                    }
                }
            }
		    
        </script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</head>
	<body>
		<form ID="WycenaŚrodkówEwidencjiWalutowej" method="post" runat="server">
			<ea:datacontext ID="dc" runat="server" TypeName="Soneta.Business.Session,Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
            <cc1:reportheader ID="ReportHeader1" title="Wycena środków w ewidencji walutowej|</strong>Ewidencja: <strong>%EWIDENCJA%|</strong>Waluta: <strong>%WALUTA%|</strong>Stan na dzień: <strong>%DATA%" runat="server"></cc1:reportheader>
            <ea:grid ID="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowsInRow="2">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn ID="colDokument" runat="server" Caption="Dokument"></ea:GridColumn>
                    <ea:GridColumn ID="colKontrahent" runat="server" Caption="Kontrahent" ColSpan="2"></ea:GridColumn>
                    <ea:GridColumn ID="colData" runat="server" Align="Center" Caption="Data" Width="12"></ea:GridColumn>
                    <ea:GridColumn ID="colKwotaZ" runat="server" Align="Right" Caption="Kwota/Z" Total="Sum" RowSpan="2" Width="15"></ea:GridColumn>
                    <ea:GridColumn ID="colWartośćZ" runat="server" Align="Right" Caption="Wartość/Z" Format="{0:n}" Total="Sum" RowSpan="2" Width="15"></ea:GridColumn>
                    <ea:GridColumn ID="colKwotaS" runat="server" Align="Right" Caption="Kwota/S" Total="Sum" RowSpan="2" Width="15"></ea:GridColumn>
                    <ea:GridColumn ID="colWartośćS" runat="server" Align="Right" Caption="Wartość/S" Format="{0:n}" Total="Sum" RowSpan="2" Width="15"></ea:GridColumn>
				</Columns>
			</ea:grid>
            <cc1:reportfooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator" runat="server"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis" runat="server"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis" runat="server"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis" runat="server"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
		</form>
	</body>
</html>

